<?php
    global $VISUAL_COMPOSER_EXTENSIONS;
	if ((class_exists('WPBakeryShortCode')) && (!class_exists('WPBakeryShortCode_TS_VCSC_Image_TiltFX'))) {
		class WPBakeryShortCode_TS_VCSC_Image_TiltFX extends WPBakeryShortCode {};
	};
    $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_VisualComposer_Element = array(
		"name"                          	=> __( "TS Image 3D TiltFX", "ts_visual_composer_extend" ),
		"base"                          	=> "TS_VCSC_Image_TiltFX",
		"icon"                          	=> "ts-composer-element-icon-image-tiltfx",
		"class"                         	=> "ts_vcsc_main_image_tiltfx",
		"category"                      	=> __( "Composium", "ts_visual_composer_extend" ),
		"description" 		            	=> __("Place an image with 3D tilt effect", "ts_visual_composer_extend"),
		"admin_enqueue_js"            		=> "",
		"admin_enqueue_css"           		=> "",
		"params"                        	=> array(
			// Image Selections
			array(
				"type"                  	=> "seperator",
				"param_name"            	=> "seperator_1",
				"seperator"					=> "Image Selections",
			),
			array(
				"type"                  	=> "attach_image",
				"holder" 					=> ($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_EditorImagePreview == "true" ? "img" : ""),
				"heading"               	=> __( "Image", "ts_visual_composer_extend" ),
				"param_name"            	=> "image",
				"class"						=> "ts_vcsc_holder_image",
				"value"                 	=> "",
				"admin_label"           	=> ($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_EditorImagePreview == "true" ? false : true),
				"description"           	=> __( "Select the image you want to use.", "ts_visual_composer_extend" )
			),
			array(
				"type"             	 		=> "switch_button",
				"heading"               	=> __( "Show Handle", "ts_visual_composer_extend" ),
				"param_name"            	=> "overlay_handle_show",
				"value"                 	=> "true",
				"edit_field_class"			=> "vc_col-sm-6 vc_column",
				"description"       		=> __( "Use the toggle to show or hide a handle indicator button below the image.", "ts_visual_composer_extend" ),
			),
			array(
				"type"                  	=> "colorpicker",
				"heading"              	 	=> __( "Handle Color", "ts_visual_composer_extend" ),
				"param_name"            	=> "overlay_handle_color",
				"value"                 	=> "#0094FF",
				"description"           	=> __( "Define the color for the handle indicator button.", "ts_visual_composer_extend" ),
				"edit_field_class"			=> "vc_col-sm-6 vc_column",
				"dependency"            	=> array( 'element' => "overlay_handle_show", 'value' => 'true' ),
			),
			// Effect Settings
			array(
				"type"				    	=> "seperator",
				"param_name"		    	=> "seperator_2",
				"seperator"					=> "Effect Settings",
			),
			array(
				"type"                  	=> "dropdown",
				"heading"               	=> __( "Trigger Event", "ts_visual_composer_extend" ),
				"param_name"            	=> "tiltfx_trigger",
				"width"                 	=> 150,
				"value" 					=> array(
					__( "Mouse / Touch on Image", "ts_visual_composer_extend" )					=> "mousetouch",
					__( "Page Scroll", "ts_visual_composer_extend" )							=> "scroll",
				),
				"description"           	=> __( "Select how the 3D tilt effect should be triggered and controlled.", "ts_visual_composer_extend" ),
				"admin_label"       		=> true,
			),
			array(
				"type"						=> "nouislider",
				"heading"					=> __( "Extra Images", "ts_visual_composer_extend" ),
				"param_name"				=> "tiltfx_extraimgs",
				"value"						=> "2",
				"min"						=> "1",
				"max"						=> "5",
				"step"						=> "1",
				"unit"						=> '',
				"description"				=> __( "Define the number of extra background image divisions.", "ts_visual_composer_extend" ),
			),
			array(
				"type"						=> "nouislider",
				"heading"					=> __( "Images Opacity", "ts_visual_composer_extend" ),
				"param_name"				=> "tiltfx_opacity",
				"value"						=> "70",
				"min"						=> "25",
				"max"						=> "80",
				"step"						=> "1",
				"unit"						=> '%',
				"description"				=> __( "Define the opacity value for the background image divisions.", "ts_visual_composer_extend" ),
			),
			array(
				"type"             	 		=> "switch_button",
				"heading"               	=> __( "Fixed Background", "ts_visual_composer_extend" ),
				"param_name"            	=> "tiltfx_bgfixed",
				"value"                 	=> "true",
				"description"       		=> __( "Use the toggle to either move or lock the first image layer.", "ts_visual_composer_extend" ),
			),			
			array(
				"type"						=> "nouislider",
				"heading"					=> __( "Transform Perspective", "ts_visual_composer_extend" ),
				"param_name"				=> "tiltfx_perspective",
				"value"						=> "1000",
				"min"						=> "600",
				"max"						=> "1200",
				"step"						=> "1",
				"unit"						=> 'px',
				"description"				=> __( "Define the perspective value for the 3D transforms.", "ts_visual_composer_extend" ),
			),
			array(
				"type"						=> "nouislider",
				"heading"					=> __( "Movement: TranslateX", "ts_visual_composer_extend" ),
				"param_name"				=> "tiltfx_translatex",
				"value"						=> "-10",
				"min"						=> "-50",
				"max"						=> "50",
				"step"						=> "1",
				"unit"						=> 'px',
				"description"				=> __( "Define the relative movement of the images along the x-axis.", "ts_visual_composer_extend" ),
			),
			array(
				"type"						=> "nouislider",
				"heading"					=> __( "Movement: TranslateY", "ts_visual_composer_extend" ),
				"param_name"				=> "tiltfx_translatey",
				"value"						=> "-10",
				"min"						=> "-50",
				"max"						=> "50",
				"step"						=> "1",
				"unit"						=> 'px',
				"description"				=> __( "Define the relative movement of the images along the y-axis.", "ts_visual_composer_extend" ),
			),
			array(
				"type"						=> "nouislider",
				"heading"					=> __( "Movement: TranslateZ", "ts_visual_composer_extend" ),
				"param_name"				=> "tiltfx_translatez",
				"value"						=> "20",
				"min"						=> "-50",
				"max"						=> "50",
				"step"						=> "1",
				"unit"						=> 'px',
				"description"				=> __( "Define the relative movement of the images along the z-axis.", "ts_visual_composer_extend" ),
			),
			array(
				"type"						=> "nouislider",
				"heading"					=> __( "Rotation: rotateX", "ts_visual_composer_extend" ),
				"param_name"				=> "tiltfx_rotatex",
				"value"						=> "2",
				"min"						=> "-6",
				"max"						=> "6",
				"step"						=> "1",
				"unit"						=> 'deg',
				"description"				=> __( "Define the relative rotation of the images along the x-axis.", "ts_visual_composer_extend" ),
			),
			array(
				"type"						=> "nouislider",
				"heading"					=> __( "Rotation: rotateY", "ts_visual_composer_extend" ),
				"param_name"				=> "tiltfx_rotatey",
				"value"						=> "2",
				"min"						=> "-6",
				"max"						=> "6",
				"step"						=> "1",
				"unit"						=> 'deg',
				"description"				=> __( "Define the relative rotation of the images along the y-axis.", "ts_visual_composer_extend" ),
			),
			array(
				"type"						=> "nouislider",
				"heading"					=> __( "Rotation: rotateZ", "ts_visual_composer_extend" ),
				"param_name"				=> "tiltfx_rotatez",
				"value"						=> "0",
				"min"						=> "-6",
				"max"						=> "6",
				"step"						=> "1",
				"unit"						=> 'deg',
				"description"				=> __( "Define the relative rotation of the images along the z-axis.", "ts_visual_composer_extend" ),
			),
			// Click Events
			array(
				"type"				    	=> "seperator",
				"param_name"		    	=> "seperator_3",
				"seperator"					=> "Click Event",
				"group" 					=> "Click Event",
			),
			array(
				"type"                  	=> "dropdown",
				"heading"               	=> __( "Click Event", "ts_visual_composer_extend" ),
				"param_name"            	=> "hover_event",
				"width"                 	=> 150,
				"value" 					=> array(
					__( "None", "ts_visual_composer_extend" )									=> "none",
					__( "Open Image in Lightbox", "ts_visual_composer_extend" )					=> "image",
					__( "Open Popup in Lightbox", "ts_visual_composer_extend" )					=> "popup",
					__( "Open YouTube Video in Lightbox", "ts_visual_composer_extend" )			=> "youtube",
					__( "Open Vimeo Video in Lightbox", "ts_visual_composer_extend" )			=> "vimeo",
					__( "Open DailyMotion Video in Lightbox", "ts_visual_composer_extend" )		=> "dailymotion",
					__( "Open Page in iFrame", "ts_visual_composer_extend" )					=> "iframe",
					__( "Simple Link to Page", "ts_visual_composer_extend" )					=> "link",
				),
				"description"           	=> __( "Select if the Hover image should trigger any other action.", "ts_visual_composer_extend" ),
				"admin_label"       		=> true,
				"group" 					=> "Click Event",
			),
			// Modal Popup
			array(
				"type"                  	=> "switch_button",
				"heading"			    	=> __( "Show Hover Title", "ts_visual_composer_extend" ),
				"param_name"		    	=> "hover_show_title",
				"value"                 	=> "true",
				"description"		    	=> __( "Switch the toggle if you want to show the title in the modal popup.", "ts_visual_composer_extend" ),
				"dependency"            	=> array( 'element' => "hover_event", 'value' => 'popup' ),
				"group" 					=> "Click Event",
			),
            array(
                "type"						=> "dropdown",
                "heading"					=> __( "Title Wrap", "ts_visual_composer_extend" ),
                "param_name"				=> "title_wrap",
                "width"						=> 150,
                "value"						=> array(
                    __( "Standard DIV", "ts_visual_composer_extend" )		=> "div",
                    __( "H1", "ts_visual_composer_extend" )					=> "h1",
                    __( "H2", "ts_visual_composer_extend" )					=> "h2",
                    __( "H3", "ts_visual_composer_extend" )					=> "h3",
                    __( "H4", "ts_visual_composer_extend" )					=> "h4",
                    __( "H5", "ts_visual_composer_extend" )					=> "h5",
                    __( "H6", "ts_visual_composer_extend" )					=> "h6",
                ),
                "description"				=> __( "Select in which DOM element type the title should be wrapped in; specific theme styling might apply.", "ts_visual_composer_extend" ),
                "standard"					=> "h3",
                "std"						=> "h3",
                "default"					=> "h3",
				"dependency"            	=> array( 'element' => "hover_event", 'value' => 'popup' ),
				"group" 					=> "Click Event",
            ), 
			array(
				"type"                  	=> "textfield",
				"heading"               	=> __( "Popup Title", "ts_visual_composer_extend" ),
				"param_name"            	=> "hover_title",
				"value"                 	=> "",
				"description"           	=> __( "Enter an optional title for the modal popup.", "ts_visual_composer_extend" ),
				"dependency"        		=> array( 'element' => "hover_event", 'value' => 'popup' ),
				"group" 					=> "Click Event",
			),				
			array(
				"type"		            	=> "textarea_html",
				"heading"               	=> __( "Popup Content", "ts_visual_composer_extend" ),
				"param_name"            	=> "content",
				"value"                 	=> "",
				"admin_label"           	=> false,
				"description"           	=> __( "Create the content for the modal popup.", "ts_visual_composer_extend" ),
				"dependency"        		=> array( 'element' => "hover_event", 'value' => 'popup' ),
				"group" 					=> "Click Event",
			),
			// YouTube / DailyMotion / Vimeo
			array(
				"type"                  	=> "textfield",
				"heading"               	=> __( "Video URL", "ts_visual_composer_extend" ),
				"param_name"            	=> "hover_video_link",
				"value"                 	=> "",
				"description"           	=> __( "Enter the URL for the video to be shown in a lightbox.", "ts_visual_composer_extend" ),
				"dependency"            	=> array( 'element' => "hover_event", 'value' => array('youtube','dailymotion','vimeo') ),
				"group" 					=> "Click Event",
			),
			array(
				"type"              		=> "switch_button",
				"heading"			    	=> __( "Show Related Videos", "ts_visual_composer_extend" ),
				"param_name"		    	=> "hover_video_related",
				"value"             		=> "false",
				"description"		    	=> __( "Switch the toggle if you want to show related videos once the video has finished playing.", "ts_visual_composer_extend" ),
				"dependency"            	=> array( 'element' => "hover_event", 'value' => 'youtube' ),
				"group" 					=> "Click Event",
			),
			array(
				"type"              		=> "switch_button",
				"heading"			    	=> __( "Autoplay Video", "ts_visual_composer_extend" ),
				"param_name"		    	=> "hover_video_auto",
				"value"             		=> "true",
				"description"		    	=> __( "Switch the toggle if you want to auto-play the video once opened in the lightbox.", "ts_visual_composer_extend" ),
				"dependency"            	=> array( 'element' => "hover_event", 'value' => array('youtube','dailymotion','vimeo') ),
				"group" 					=> "Click Event",
			),
			// Link / iFrame
			array(
				"type" 						=> ($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_ParameterLinkPicker['enabled'] == "false" ? "vc_link" : "advancedlinks"),
				"heading" 					=> __("Link + Title", "ts_visual_composer_extend"),
				"param_name" 				=> "hover_link",
				"description" 				=> __("Provide a link to another site/page to be used for the Hover event.", "ts_visual_composer_extend"),
				"dependency"            	=> array( 'element' => "hover_event", 'value' => array('iframe','link') ),
				"group" 					=> "Click Event",
			),
			// Image Tooltip
			array(
				"type"						=> "seperator",
				"param_name"				=> "seperator_4",
				"seperator"					=> "Tooltip Settings",
				"group" 					=> "Tooltip Settings",
			),
			array(
				"type"              		=> ($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_EditorBase64TinyMCE == "true" ? "wysiwyg_base64" : "textarea_raw_html"),
				"heading"           		=> __( "Tooltip Content", "ts_visual_composer_extend" ),
				"param_name"        		=> "tooltip_content_html",
				"minimal"					=> "true",
				"value"             		=> base64_encode(""),
				"description"      	 		=> __( "Enter the tooltip content here; HTML code can be used.", "ts_visual_composer_extend" ),
				"group" 					=> "Tooltip Settings",
			),
			array(
				"type"						=> "dropdown",
				"heading"					=> __( "Tooltip Style", "ts_visual_composer_extend" ),
				"param_name"				=> "tooltip_style",
				"value"             		=> $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_ToolTipster_Layouts,
				"description"				=> __( "Select the tooltip style.", "ts_visual_composer_extend" ),
				"group" 					=> "Tooltip Settings",
			),
			array(
				"type"						=> "nouislider",
				"heading"					=> __( "Tooltip X-Offset", "ts_visual_composer_extend" ),
				"param_name"				=> "tooltipster_offsetx",
				"value"						=> "0",
				"min"						=> "-100",
				"max"						=> "100",
				"step"						=> "1",
				"unit"						=> 'px',
				"description"				=> __( "Define an optional X-Offset for the tooltip position.", "ts_visual_composer_extend" ),
				"group" 					=> "Tooltip Settings",
			),
			array(
				"type"						=> "nouislider",
				"heading"					=> __( "Tooltip Y-Offset", "ts_visual_composer_extend" ),
				"param_name"				=> "tooltipster_offsety",
				"value"						=> "0",
				"min"						=> "-100",
				"max"						=> "100",
				"step"						=> "1",
				"unit"						=> 'px',
				"description"				=> __( "Define an optional Y-Offset for the tooltip position.", "ts_visual_composer_extend" ),
				"group" 					=> "Tooltip Settings",
			),
			// Lightbox Settings
			array(
				"type"                  	=> "seperator",
				"param_name"            	=> "seperator_5",
				"seperator"					=> "Lightbox Settings",
				"dependency"            	=> array( 'element' => "hover_event", 'value' => array('image', 'popup', 'youtube', 'vimeo', 'dailymotion', 'iframe') ),
				"group" 					=> "Lightbox Settings",
			),
			array(
				"type"             	 		=> "switch_button",
				"heading"			    	=> __( "Create AutoGroup", "ts_visual_composer_extend" ),
				"param_name"		    	=> "lightbox_group",
				"value"				    	=> "true",
				"description"       		=> __( "Switch the toggle if you want the plugin to group this image with all other non-gallery images on the page.", "ts_visual_composer_extend" ),
				"dependency"            	=> array( 'element' => "hover_event", 'value' => array('image', 'popup', 'youtube', 'vimeo', 'dailymotion', 'iframe') ),
				"group" 					=> "Lightbox Settings",
			),
			array(
				"type"                  	=> "textfield",
				"heading"               	=> __( "Group Name", "ts_visual_composer_extend" ),
				"param_name"            	=> "lightbox_group_name",
				"value"                 	=> "",
				"admin_label"           	=> true,
				"description"           	=> __( "Enter a custom group name to manually build group with other non-gallery items.", "ts_visual_composer_extend" ),
				"dependency"            	=> array( 'element' => "lightbox_group", 'value' => 'false' ),
				"group" 					=> "Lightbox Settings",
			),
			array(
				"type"                  	=> "dropdown",
				"heading"               	=> __( "Transition Effect", "ts_visual_composer_extend" ),
				"param_name"            	=> "lightbox_effect",
				"width"                 	=> 150,
				"value"                 	=> $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Lightbox_Animations,
				"default" 					=> $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_LightboxDefaultAnimation,
				"std" 						=> $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_LightboxDefaultAnimation,
				"admin_label"           	=> true,
				"description"           	=> __( "Select the transition effect to be used for the image in the lightbox.", "ts_visual_composer_extend" ),
				"dependency"            	=> array( 'element' => "hover_event", 'value' => array('image', 'popup', 'youtube', 'vimeo', 'dailymotion', 'iframe') ),
				"group" 					=> "Lightbox Settings",
			),
			array(
				"type"                  	=> "dropdown",
				"heading"               	=> __( "Backlight Effect", "ts_visual_composer_extend" ),
				"param_name"            	=> "lightbox_backlight",
				"width"                 	=> 150,
				"value"                 	=> array(
					__( 'Auto Color', "ts_visual_composer_extend" )       											=> "auto",
					__( 'Custom Color', "ts_visual_composer_extend" )     											=> "custom",
					__( 'Transparent Backlight', "ts_visual_composer_extend" )     	=> "hideit",
				),
				"admin_label"           	=> true,
				"description"           	=> __( "Select the backlight effect for the image.", "ts_visual_composer_extend" ),
				"dependency"            	=> array( 'element' => "hover_event", 'value' => array('image', 'popup', 'youtube', 'vimeo', 'dailymotion', 'iframe') ),
				"group" 					=> "Lightbox Settings",
			),
			array(
				"type"                  	=> "colorpicker",
				"heading"               	=> __( "Custom Backlight Color", "ts_visual_composer_extend" ),
				"param_name"            	=> "lightbox_backlight_color",
				"value"                 	=> "#ffffff",
				"description"           	=> __( "Define the backlight color for the lightbox image.", "ts_visual_composer_extend" ),
				"dependency"            	=> array( 'element' => "lightbox_backlight", 'value' => 'custom' ),
				"group" 					=> "Lightbox Settings",
			),
			// Other Settings
			array(
				"type"                  	=> "seperator",
				"param_name"            	=> "seperator_6",
				"seperator"                 => "Other Settings",
				"group" 					=> "Other Settings",
			),
			array(
				"type"                  	=> "nouislider",
				"heading"               	=> __( "Margin: Top", "ts_visual_composer_extend" ),
				"param_name"            	=> "margin_top",
				"value"                 	=> "0",
				"min"                   	=> "0",
				"max"                   	=> "200",
				"step"                 	 	=> "1",
				"unit"                  	=> 'px',
				"description"           	=> __( "Select the top margin for the element.", "ts_visual_composer_extend" ),
				"group" 					=> "Other Settings",
			),
			array(
				"type"                  	=> "nouislider",
				"heading"               	=> __( "Margin: Bottom", "ts_visual_composer_extend" ),
				"param_name"            	=> "margin_bottom",
				"value"                 	=> "0",
				"min"                   	=> "0",
				"max"                   	=> "200",
				"step"                 	 	=> "1",
				"unit"                  	=> 'px',
				"description"           	=> __( "Select the bottom margin for the element.", "ts_visual_composer_extend" ),
				"group" 					=> "Other Settings",
			),
			array(
				"type"                  	=> "textfield",
				"heading"               	=> __( "Define ID Name", "ts_visual_composer_extend" ),
				"param_name"            	=> "el_id",
				"value"                 	=> "",
				"description"          	 	=> __( "Enter an unique ID for the element.", "ts_visual_composer_extend" ),
				"group" 					=> "Other Settings",
			),
			array(
				"type"                  	=> "tag_editor",
				"heading"           		=> __( "Extra Class Names", "ts_visual_composer_extend" ),
				"param_name"            	=> "el_class",
				"value"                 	=> "",
				"description"      			=> __( "Enter additional class names for the element.", "ts_visual_composer_extend" ),
				"group" 					=> "Other Settings",
			),
		)
	);	
	if ($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_VisualComposer_LeanMap == "true") {
		return $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_VisualComposer_Element;
	} else {			
		vc_map($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_VisualComposer_Element);
	};
?>